/**
*    CubeFrame.cpp
*    
*    Extention of Routine to expand and contract a wireframe of a cube.
*    
*    Program written by Lopuz3
*    Spring 2013 
**/

#include "Arduino.h"
#include "CubeFrame.h"

CubeFrame::CubeFrame()
{
	timeSinceLastExpantion = 0;
	wireframeSize = 0;
	growing = true;
	xHigh = random(2);
	yHigh = random(2);
	zHigh = random(2);
}	

void CubeFrame::update (unsigned long dt)
{
	timeSinceLastExpantion += dt;
	if (timeSinceLastExpantion > STEP_TIME)
	{
		for(byte x=0 ; x < CUBE_SIZE ; x++)
		{
			for(byte y=0 ; y < CUBE_SIZE ; y++)
			{
				for(byte z=0 ; z < CUBE_SIZE ; z++)
				{
					int xDist = x;
					if(xHigh)
					{
						xDist = CUBE_SIZE -x -1;
					}
					int yDist = y;
					if(yHigh)
					{
						yDist = CUBE_SIZE -y -1;
					}
					int zDist = z;
					if(zHigh)
					{
						zDist = CUBE_SIZE -z -1;
					}
					if( xDist < wireframeSize && yDist < wireframeSize && zDist < wireframeSize)
					{
						int count = 0;
						if(xDist == 0 || xDist == wireframeSize -1)
						{
							count++;
						}
						if(yDist == 0 || yDist == wireframeSize -1)
						{
							count++;
						}
						if(zDist == 0 || zDist == wireframeSize -1)
						{
							count++;
						}
						
						if(count >= 2)
						{
							cubeModel[x][y][z] = true;
						}
						else
						{
							cubeModel[x][y][z] = false;
						}
					}
					else
					{
						cubeModel[x][y][z] = false;
					}
				}
			}
		}
		
		if(wireframeSize == CUBE_SIZE)
		{
			growing = false;
		}
		if(wireframeSize == 0)
		{
			growing = true;
			xHigh = random(2);
			yHigh = random(2);
			zHigh = random(2);
		}
		if(growing)
		{
			wireframeSize++;
		}
		else
		{
			wireframeSize--;
		}
		timeSinceLastExpantion-= STEP_TIME;
	}
}